	function kk = COMPLETE_ELLIPTIC_INTEGRAL(K)
	
	%	 Computes the Complete Elliptic Integral
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1984-01-13
	% 	Modified by:	LW, 1991-06-09, 2000-10-31,2002-09-05, 2004-09-22
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1  
	% 	Known Bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	% 	Reference:		Daniels R.W.: Approximation Methods for Electronic Filter Design, 
	%					McGraw-Hill, 1974.
 
		A(1) = atan(K/sqrt(1-K*K));
		Q(1) = pi/2;
		p = 1;
		n = 1;
		delta = 1;
		while delta > 0.0000001 
			X = 2/(1+ sin(A(n))) - 1;
			Y = sin(A(n))*sin(Q(n));
			A(n+1) = atan(sqrt(1-X*X)/X);
			Q(n+1) = 0.5*(Q(n) + atan(Y/sqrt(1-Y*Y)));
			delta = 1 - 2*A(n+1)/pi;
			n = n+1;
		end
		for j = 2:n
			p = p*(1 + cos(A(j)));
		end
		kk = log10(tan(0.25*pi + 0.5*Q(n)))*p;
